﻿using System;
using System.IO;
using System.Diagnostics;
using Pgm;

class PgmCreatorDemo {
	
	//TYPICAL USAGE OF THE PGMCREATOR CLASS:
	static void MakeLenaBlackWhite() {
		// for the specification of PGM-Files, see: http://netpbm.sourceforge.net/doc/pgm.html
		
		// A byte-array is used for storing the gray-color-values.
		// The img has the size 256x256 pixel;
		// Each pixel has a gray-color-value from 0-255 (0...black, 255...white).
		// Note also that the FIRST dimension (row-index) corresponds
		// to the x-Coordinate (!!!) in the image, the second dimension (col-index)
		// to the y-coordinate (!!!). The y coordinate goes from up to down!
		// Thus, an index of [50, 250] is at the left and bottom of the image.
		// (The Write/ReadPGM-Methods internally transpose the matrix.)
		
		// Open Lena, make it black-white (threshold is the value 128), and save it:
		try {
			byte[,] lenaImgData = PgmCreator.ReadPgmFile("lena.pgm");
			for (int x = 0; x < lenaImgData.GetLength(0); x++) {
				for (int y = 0; y < lenaImgData.GetLength(1); y++) {
					if (lenaImgData[x, y] < 128) lenaImgData[x, y] = 0;
					else lenaImgData[x, y] = 255;
				}
			}
			PgmCreator.WritePgmFile("lena_black_white.pgm", lenaImgData, PgmType.P5);
		    Console.WriteLine("Success making Lena black-white!");
		}
		catch (FileNotFoundException e) {
			Console.WriteLine("Where ist the file? " + e.Message);
		}
		catch (FormatException e) {
			Console.WriteLine("Wrong file format: " + e.Message);
		}
		catch (Exception e) {
			Console.WriteLine(e.Message);
		}
	}
		
	static void Main(string[] args) { 
		TestBinaryAndASCIIFormat();
		MakeLenaBlackWhite();
	}
	
	//Helper Method which produces a byte-array representing a gradient image:
    private static byte[,] ProduceGradientImage() {
		byte[,] imgData = new byte[256, 256];

        // fill the imgData-Array with the gray-color-values:
        for (int y = 0; y < imgData.GetLength(1); y++) {
            for (int x = 0; x < imgData.GetLength(0); x++) {
                // produce a gray-color gradient image:
				// top-left corner: black, bottom-right corner: white.
				// Note that x and y go from 0 to 255, so x/2 + y/2 cannot exceed the value 254.
				imgData[x, y] = (byte)(x / 2 + y / 2);
            }
        }
		return imgData;
	}
	
	//Tests whether both pgm file formats work:
	private static void TestBinaryAndASCIIFormat() {
		byte[,] imgData = ProduceGradientImage();
	
		byte[,] readDataAscii; 
		byte[,] readDataBinary;
		try {
			// write imgData to P2 file (ascii):
			PgmCreator.WritePgmFile("testASCII.pgm", imgData, PgmType.P2);
			// read from P2 file (ascii): 
			readDataAscii = PgmCreator.ReadPgmFile("testASCII.pgm");
			// write image data to P5 file (binary): 
			PgmCreator.WritePgmFile("testBinary.pgm", readDataAscii, PgmType.P5);
			// read P5 file (binary):
			readDataBinary = PgmCreator.ReadPgmFile("testBinary.pgm");
			
			 //check if the image loaded from the P2-type file (ascii) 
			 //is the same as from the P5-type file (binary):
			for (int y = 0; y < imgData.GetLength(1); y++) {
				for (int x = 0; x < imgData.GetLength(0); x++) {
					Debug.Assert(readDataAscii[x,y] == readDataBinary[x,y]);
				}
			}
			Console.WriteLine("Success in testing two generated files of both types!");
		} catch (Exception e) {
			Console.WriteLine(e.Message);
		}
	}
}
